/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.launching.server;

import com.aptana.php.debug.core.server.PHPServersManager;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.webserver.core.IServer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org2.eclipse.php.internal.core.util.FileUtils;
import org2.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org2.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org2.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org2.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org2.eclipse.php.internal.debug.ui.launching.server.PHPWebPageURLLaunchDialog;

public class PHPWebPageLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            PHPWebPageLaunchShortcut.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, this.getPHPServerLaunchConfigType());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file != null) {
            PHPWebPageLaunchShortcut.searchAndLaunch(new Object[]{file}, mode, this.getPHPServerLaunchConfigType());
        }
    }

    private ILaunchConfigurationType getPHPServerLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("com.aptana.php.debug.core.launching.webPageLaunch");
    }

    public static void searchAndLaunch(Object[] search, String mode, ILaunchConfigurationType configType) {
        int entries = search == null ? 0 : search.length;
        int i = 0;
        while (i < entries) {
            try {
                ILaunchConfiguration config;
                String phpPathString = null;
                IProject project = null;
                Object obj = search[i];
                if (obj instanceof IFile) {
                    IFile file = (IFile)obj;
                    project = file.getProject();
                    IContentType contentType = Platform.getContentTypeManager().getContentType("com.aptana.contenttype.phtml.php");
                    if (contentType.isAssociatedWith(file.getName())) {
                        phpPathString = file.getFullPath().toString();
                    }
                }
                if (phpPathString == null) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.php.debug.epl", 0, PHPDebugUIMessages.launch_failure_no_target, null));
                }
                IServer defaultServer = PHPServersManager.getDefaultServer(project);
                if (defaultServer == null) {
                    PHPDebugEPLPlugin.createDefaultPHPServer();
                    defaultServer = PHPServersManager.getDefaultServer((IProject)project);
                    if (defaultServer == null) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.php.debug.epl", 0, "Could not create a defualt server for the launch.", null));
                    }
                }
                if ((config = PHPWebPageLaunchShortcut.findLaunchConfiguration(project, phpPathString, defaultServer, mode, configType)) != null) {
                    DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
                }
            }
            catch (CoreException ce) {
                final IStatus stat = ce.getStatus();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog.openError((Shell)PHPDebugEPLPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_failure_msg_title, (String)PHPDebugUIMessages.launch_failure_server_msg_text, (IStatus)stat);
                    }
                });
            }
            ++i;
        }
    }

    static ILaunchConfiguration findLaunchConfiguration(IProject project, String fileName, IServer server, String mode, ILaunchConfigurationType configType) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int numConfigs = configs == null ? 0 : configs.length;
            int i = 0;
            while (i < numConfigs) {
                String configuredServerName = configs[i].getAttribute("ATTR_SERVER_NAME", null);
                String configuredFileName = configs[i].getAttribute("ATTR_SERVER_FILE_NAME", null);
                if (configuredFileName.equals(fileName) && server.getName().equals(configuredServerName)) {
                    config = configs[i].getWorkingCopy();
                    break;
                }
                ++i;
            }
            if (config == null) {
                config = PHPWebPageLaunchShortcut.createConfiguration(project, fileName, server, configType, mode);
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return config;
    }

    static String computeContextRoot(String url, String fileName, IServer server) {
        String serverBaseURL = server.getBaseURL().toString();
        if (url.length() > serverBaseURL.length() + 1) {
            url = url.substring(serverBaseURL.length() + 1);
        } else if (url.length() == serverBaseURL.length() || url.length() == serverBaseURL.length() + 1) {
            return "";
        }
        if (fileName.length() > 0) {
            int pathIndex = (fileName = fileName.substring(1)).indexOf(47);
            fileName = pathIndex < 0 ? "" : fileName.substring(pathIndex);
        }
        if (url.length() <= fileName.length()) {
            return "";
        }
        url = url.substring(0, url.length() - fileName.length());
        return url;
    }

    static ILaunchConfiguration createConfiguration(IProject project, String fileName, IServer server, ILaunchConfigurationType configType, String mode) throws CoreException {
        ILaunchConfiguration config = null;
        if (!FileUtils.resourceExists(fileName)) {
            return null;
        }
        String URL2 = server.getBaseURL() + new Path(fileName).toString();
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, PHPWebPageLaunchShortcut.getNewConfigurationName(fileName));
        String debuggerID = PHPProjectPreferences.getDefaultDebuggerID(project);
        wc.setAttribute("com.aptana.php.debug.php_debugger_id", debuggerID);
        AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(debuggerID);
        wc.setAttribute("com.aptana.php.debug.configurationDelegateClass", debuggerConfiguration.getWebLaunchDelegateClass());
        wc.setAttribute("ATTR_SERVER_NAME", server.getName());
        wc.setAttribute("ATTR_SERVER_FILE_NAME", fileName);
        wc.setAttribute("ATTR_SERVER_BASE_URL", URL2);
        wc.setAttribute("org2.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugEPLPlugin.getDebugInfoOption());
        wc.setAttribute("org2.eclipse.php.debug.core.OpenInBrowser", PHPDebugEPLPlugin.getOpenInBrowserOption());
        wc.setAttribute("firstLineBreakpoint", PHPProjectPreferences.getStopAtFirstLine(project));
        String title = "debug".equals(mode) ? "Debug PHP Web Page" : "Run PHP Web Page";
        PHPWebPageURLLaunchDialog launchDialog = new PHPWebPageURLLaunchDialog(wc, server, title);
        launchDialog.setBlockOnOpen(true);
        if (launchDialog.open() == 0) {
            config = wc.doSave();
            return config;
        }
        return null;
    }

    protected static String getNewConfigurationName(String fileName) {
        String configurationName = "New_configuration";
        try {
            IPath path = Path.fromOSString((String)fileName);
            String fileExtention = path.getFileExtension();
            String lastSegment = path.lastSegment();
            if (lastSegment != null) {
                if (fileExtention != null) {
                    lastSegment = lastSegment.replaceFirst("." + fileExtention, "");
                }
                configurationName = lastSegment;
            }
        }
        catch (Exception e) {
            PHPDebugEPLPlugin.logError("Could not generate configuration name for " + fileName + ".\nThe default name will be used.", e);
        }
        return DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configurationName);
    }
}

